#!/bin/sh

echo ""
echo "Download and install these first (if you don't have them already):"

echo ""
echo "Net-SNMP - http://net-snmp.sourceforge.net/"
echo "SEC      - http://simple-evcorr.sourceforge.net/"
echo "SNMPTT   - http://snmptt.sourceforge.net/"
echo "Text::Autoformat from CPAN"

echo ""
echo "There's installation notes in the INSTALL file"

echo ""
echo "Run this script as 'root' since it will copy files to the '/etc' directory'"

echo ""
echo "This is a simple installation script.  You should read the contents first."
echo "You've been warned!"

echo ""
echo "Where is Hobbit installed [/home/hobbit]: "
read HOBBITDIR

if test "$HOBBITDIR" = ""; then
        HOBBITDIR=/home/hobbit
fi


echo "Looking for Hobbit in $HOBBITDIR..."

if test -d "$HOBBITDIR/server" ; then
  echo "$HOBBITDIR/server exists!!!"
else
  echo "error: $HOBBITDIR/server does NOT exist!!!"
  exit
fi


echo ""
/bin/mkdir -p /etc/snmp
/bin/mkdir -p /var/log/snmp
/bin/mkdir -p /var/spool/snmptt
/bin/touch /var/log/snmp/snmpttunknown.log

echo ""
echo "Copying logrotate.d/* files to /etc/logrotate.d"
/bin/cp -ia logrotate.d/* /etc/logrotate.d

echo ""
echo "Copying rc.d/* files to /etc/rc.d"
/bin/cp -ia rc.d/* /etc/rc.d

echo ""
echo "Copying sec.conf/* files to /usr/local/etc"
/bin/cp -ia sec.conf /usr/local/etc

echo ""
echo "Copying snmp/* files to /etc/snmp"
/bin/cp -ia snmp/* /etc/snmp

echo ""
echo "Copying server/* files to $HOBBITDIR/server"
/bin/cp -ia server/* $HOBBITDIR/server

echo ""
echo "================================================================="
echo "Edit the path to hobbit in $HOBBITDIR/server/etc/hobbitlaunch.cfg-trap
echo ""
echo "Copy the contents of:"
echo "  $HOBBITDIR/server/etc/hobbitlaunch.cfg-trap"
echo "into:"
echo "  $HOBBITDIR/server/etc/hobbitlaunch.cfg"
echo ""
echo "Edit the /etc/snmp/snmptrapd.conf with your SNMP community name"
echo ""
echo "Update your rc.local or rc.d files as needed to handle various rc.d scripts"
echo ""
echo ""
echo "The makeconf.sh script in the mibs directory will make some"
echo "initial snmptt.conf files for the standard MIBs, Cisco, and APC"
echo "================================================================="
echo ""
