#!/bin/sh

echo ""
echo "Getting Standard MIBs"
export MIBDIRS=/usr/local/share/snmp/mibs
rm -f errors.std
for i in /usr/local/share/snmp/mibs/*
do
echo "Getting Traps from $i..."
/usr/local/sbin/snmpttconvertmib \
    --format_desc=6 \
    --net_snmp_perl \
    --in=$i \
    --out=snmptt.conf \
    1> /dev/null 2>>errors.std
done

echo ""
echo "Getting APC MIB"
mkdir -p apc
cd apc
ncftpget ftp://ftp.apc.com/apc/public/software/pnetmib/mib/383/powernet383.mib
cd ..
echo "Getting Traps from APC MIB... (It's a big file)"
export MIBDIRS=/usr/local/share/snmp/mibs
rm -f errors.apc
/usr/local/sbin/snmpttconvertmib \
    --format_desc=6 \
    --net_snmp_perl \
    --in=apc/powernet383.mib \
    --out=snmptt.conf.apc \
    1> /dev/null 2>>errors.apc


echo ""
echo "==========================="
echo ""
echo "Getting Cisco MIBs"
mkdir -p cisco
cd cisco
ncftpget ftp://ftp.cisco.com/pub/mibs/v1/v1.tar.gz
tar  -zxvf v1.tar.gz
cd ..
export MIBDIRS=/usr/local/share/snmp/mibs:$PWD/cisco
rm -f errors.cisco
for i in cisco/*my
do
echo "Getting Traps from $i..."
/usr/local/sbin/snmpttconvertmib \
    --format_desc=6 \
    --net_snmp_perl \
    --in=$i \
    --out=snmptt.conf.cisco \
    1> /dev/null 2>>errors.cisco
done

echo ""
echo "==========================="

echo ""
echo "Copying snmptt.conf.* files to /etc/snmp"
/bin/cp -i snmptt.conf* /etc/snmp

echo ""
echo "Update /etc/snmp/snmptt.ini if necessary"
echo "Restart snmptt"

